<?php

namespace app\components;

use Google_Client;
use Google_Service_Calendar;
use Google_Service_Calendar_Event;

class GoogleCalendarService
{
    private $service;
    private $calendarId = 'cakraatmajaya@gmail.com'; // Ganti dengan email Google Calendar Anda

    public function __construct()
    {
        $client = new Google_Client();
        $client->setApplicationName('Yii2 Calendar App');
        $client->setScopes(Google_Service_Calendar::CALENDAR);
        $client->setAuthConfig(\Yii::getAlias('@app/credentials/credentials.json'));

        $this->service = new Google_Service_Calendar($client);
    }

    public function createEvent($summary, $description, $startDateTime, $endDateTime)
    {
        $event = new Google_Service_Calendar_Event([
            'summary' => $summary,
            'description' => $description,
            'start' => [
                'dateTime' => $startDateTime,
                'timeZone' => 'Asia/Makassar',
            ],
            'end' => [
                'dateTime' => $endDateTime,
                'timeZone' => 'Asia/Makassar',
            ],
            'reminders' => [
                'useDefault' => false,
                'overrides' => [
                    ['method' => 'email', 'minutes' => 30],
                    ['method' => 'popup', 'minutes' => 10],
                ],
            ],
        ]);

        $createdEvent = $this->service->events->insert($this->calendarId, $event);
        return $createdEvent->htmlLink;
    }

    // List semua event dalam rentang waktu tertentu
public function listEvents($maxResults = 10)
{
    $optParams = [
        'maxResults' => $maxResults,
        'orderBy' => 'startTime',
        'singleEvents' => true,
        'timeMin' => date('c'), // hanya future events
    ];

    $results = $this->service->events->listEvents($this->calendarId, $optParams);
    return $results->getItems();
}


// Get satu event
public function getEvent($eventId)
{
    return $this->service->events->get($this->calendarId, $eventId);
}

// Update event
public function updateEvent($eventId, $summary, $description, $startDateTime, $endDateTime)
{
    $event = $this->service->events->get($this->calendarId, $eventId);

    $event->setSummary($summary);
    $event->setDescription($description);
    $event->setStart(new \Google_Service_Calendar_EventDateTime([
        'dateTime' => $startDateTime,
        'timeZone' => 'Asia/Makassar',
    ]));
    $event->setEnd(new \Google_Service_Calendar_EventDateTime([
        'dateTime' => $endDateTime,
        'timeZone' => 'Asia/Makassar',
    ]));

    $updatedEvent = $this->service->events->update($this->calendarId, $eventId, $event);
    return $updatedEvent->htmlLink;
}

// Hapus event
public function deleteEvent($eventId)
{
    return $this->service->events->delete($this->calendarId, $eventId);
}




}



