<?php
namespace app\components;

use Google_Client;
use Google_Service_Sheets;
use Google_Service_Sheets_ValueRange;
use Google\Client;
use Google\Service\Sheets;

class GoogleSheetService
{
    private $spreadsheetId = '1p_1Og2smQfy6lq-4QIAM8r7rHQnWGXvJGePkICI19jM'; // ganti dengan ID spreadsheet Anda
    private $range = 'Sheet1!A2:C';
    private $service;

    

    public function __construct()
    {
        $client = new Google_Client();
        $client->setApplicationName('Yii2 Google Sheets App');
        $client->setScopes([Google_Service_Sheets::SPREADSHEETS]);
        $client->setAuthConfig(\Yii::getAlias('@app/credentials/credentials.json'));

        $this->service = new Google_Service_Sheets($client);
    }

    public function getAllData()
    {
        $response = $this->service->spreadsheets_values->get($this->spreadsheetId, $this->range);
        return $response->getValues();
    }

    public function appendRow($data)
    {
        $valueRange = new Google_Service_Sheets_ValueRange([
            'values' => [$data]
        ]);

        $params = ['valueInputOption' => 'USER_ENTERED'];
        return $this->service->spreadsheets_values->append(
            $this->spreadsheetId,
            $this->range,
            $valueRange,
            $params
        );
    }
        public function getData($spreadsheetId, $range)
    {
        $response = $this->service->spreadsheets_values->get($spreadsheetId, $range);
        return $response->getValues();
    }
}


