<?php

namespace app\controllers;
use app\models\EventForm;

use Yii;
use yii\web\Controller;
use app\components\GoogleCalendarService;
use app\models\CalendarEvent;

class CalendarController extends Controller
{
    public function actionCreateEvent()
{
    $model = new EventForm();
    $link = null;

    if ($model->load(Yii::$app->request->post()) && $model->validate()) {
        $calendar = new \app\components\GoogleCalendarService();
        $start = $model->start . ':00+08:00';
        $end = $model->end . ':00+08:00';

    $link = $calendar->createEvent(
    $model->summary,
    $model->description,
    $start,
    $end
        );
    }
   

    return $this->render('create-event', [
        'model' => $model,
        'link' => $link
    ]);
}
public function actionIndex()
{
    $calendar = new \app\components\GoogleCalendarService();
    $events = $calendar->listEvents(20);
    return $this->render('index', ['events' => $events]);
}

public function actionUpdate($id)
{
    $calendar = new \app\components\GoogleCalendarService();
    $event = $calendar->getEvent($id);
   

    // Inisialisasi form model dengan data dari event Google Calendar
    $model = new \app\models\EventForm([
        'summary' => $event->getSummary(),
        'description' => $event->getDescription(),
        'start' => date('Y-m-d\TH:i', strtotime($event->getStart()->getDateTime())),
        'end' => date('Y-m-d\TH:i', strtotime($event->getEnd()->getDateTime())),
    ]);

    // Jika data form di-submit dan valid
    if ($model->load(Yii::$app->request->post()) && $model->validate()) {
        $calendar->updateEvent($id, $model->summary, $model->description, $model->start, $model->end);

        // Untuk request AJAX (misalnya dari modal)
        if (Yii::$app->request->isAjax) {
            // Gunakan ID container Pjax yang sesuai
            return "<script>
                $('#editModal').modal('hide');
                $.pjax.reload({container:'#event-list'});
            </script>";
        }

        // Untuk request biasa (non-AJAX)
        return $this->redirect(['index']);
    }

    // Render form edit via AJAX jika permintaan dari modal
    if (Yii::$app->request->isAjax) {
        return $this->renderAjax('_form-event', ['model' => $model]);
    }

    // Render form edit biasa (misalnya fallback)
    return $this->render('update-event', ['model' => $model]);
}


public function actionDelete($id)
{
    $calendar = new \app\components\GoogleCalendarService();
    $calendar->deleteEvent($id);
    return $this->redirect(['index']);
}

public function actionSync()
{
    $calendar = new \app\components\GoogleCalendarService();
    $events = $calendar->listEvents(100);

    $synced = 0;

    foreach ($events as $event) {
        $exists = CalendarEvent::findOne(['event_id' => $event->getId()]);
        if (!$exists) {
            $model = new CalendarEvent();
            $model->event_id = $event->getId();
            $model->summary = $event->getSummary();
            $model->description = $event->getDescription();
            $model->start_time = date('Y-m-d H:i:s', strtotime($event->getStart()->dateTime));
            $model->end_time = date('Y-m-d H:i:s', strtotime($event->getEnd()->dateTime));
            if ($model->save()) {
                $synced++;
            }
        }
    }

    Yii::$app->session->setFlash('success', "$synced event baru disinkronisasi.");
    return $this->redirect(['index']);
}

public function actionEditEvent($id)
{
    $calendar = new \app\components\GoogleCalendarService();
    $event = $calendar->getEvent($id);

    $model = new \app\models\EventForm();
    $model->summary = $event->getSummary();
    $model->description = $event->getDescription();
    $model->start = date('Y-m-d\TH:i', strtotime($event->getStart()->getDateTime()));
    $model->end = date('Y-m-d\TH:i', strtotime($event->getEnd()->getDateTime()));

    $startDateTime = new \DateTime($event->getStart()->getDateTime());
    $startDateTime->setTimezone(new \DateTimeZone('Asia/Makassar'));
    $model->start = $startDateTime->format('Y-m-d\TH:i');

    $endDateTime = new \DateTime($event->getEnd()->getDateTime());
    $endDateTime->setTimezone(new \DateTimeZone('Asia/Makassar'));
    $model->end = $endDateTime->format('Y-m-d\TH:i');

       

    $link = null;

    if ($model->load(Yii::$app->request->post()) && $model->validate()) {
        $link = $calendar->updateEvent(
            $id,
            $model->summary,
            $model->description,
            $start,
            $end
        );
    }

    return $this->render('edit-event', [
        'model' => $model,
        'link' => $link,
        'id' => $id
    ]);
}

public function actionListEvents()
{
    $calendar = new \app\components\GoogleCalendarService();
    $events = $calendar->listEvents(20); // Ambil 20 event terdekat

    
    return $this->render('list-events', [
        'events' => $events,
    ]);
}

}
