<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%calendar_event}}`.
 */
class m250527_075104_create_calendar_event_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('calendar_event', [
            'id' => $this->primaryKey(),
            'event_id' => $this->string()->notNull()->unique(),
            'summary' => $this->string()->notNull(),
            'description' => $this->text(),
            'start_time' => $this->dateTime()->notNull(),
            'end_time' => $this->dateTime()->notNull(),
            'created_at' => $this->timestamp()->defaultExpression('CURRENT_TIMESTAMP'),
        ]);
    }
    
    public function safeDown()
    {
        $this->dropTable('calendar_event');
    }
}
