<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "calendar_event".
 *
 * @property int $id
 * @property string|null $event_id
 * @property string|null $summary
 * @property string|null $description
 * @property string|null $start_datetime
 * @property string|null $end_datetime
 * @property string|null $created_at
 */
class CalendarEvent extends \yii\db\ActiveRecord
{


    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'calendar_event';
    }

    public function rules()
    {
        return [
            [['event_id', 'summary', 'start_time', 'end_time'], 'required'],
            [['description'], 'string'],
            [['start_time', 'end_time'], 'safe'],
            [['event_id'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'event_id' => 'Event ID',
            'summary' => 'Summary',
            'description' => 'Description',
            'start_datetime' => 'Start Datetime',
            'end_datetime' => 'End Datetime',
            'created_at' => 'Created At',
        ];
    }

}
